% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HandleFeatures.R
\name{gene2tx}
\alias{gene2tx}
\title{Translate gene names to transcript ids using a GTF file for a subset
of genes}
\usage{
gene2tx(gtfFile, geneList, geneCol = 1)
}
\arguments{
\item{gtfFile}{path to a GTF file}

\item{geneList}{path to a tab-delimited text file with one gene name on each
line, or a character vector of gene names (eg. RPRD1B)}

\item{geneCol}{the position of the column that containing gene names in the
case that geneList is a file}
}
\value{
a vector of transcript ids (eg. ENST00000577222.1)
}
\description{
Given a list of gene names in a file or in a character vector,
turn them into a vector of transcript ids.
}
\examples{

gtfFile <- system.file("extdata", "gencode.v19.annotation_chr19.gtf",
    package = "GenomicPlot"
)
genes <- c("RPRD1A", "RPAP2", "RPRD1B", "RPRD2", "ZNF281", "YTHDF2")

tx <- gene2tx(gtfFile = gtfFile, geneList = genes)

}
\author{
Shuye Pu
}
