% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CNV.R
\name{differential_CNV}
\alias{differential_CNV}
\title{Do difference analysis of gene level copy number variation data}
\usage{
differential_CNV(
  cnvData,
  sampleGroup,
  method = "Chisquare",
  adjust.method = "BH",
  ...
)
}
\arguments{
\item{cnvData}{data.frame of CNV data, each column is a sample, 
and each row is a CNV.}

\item{sampleGroup}{vector of sample group}

\item{method}{method to do diffenenital analysis, 
one of "Chisquare", "fisher",
and "CATT"(Cochran-Armitage trend test)}

\item{adjust.method}{adjust.method, one of "holm", "hochberg", "hommel", 
"bonferroni", "BH", "BY", "fdr", and "none".}

\item{...}{parameters for "Chisquare", "fisher",
and "CATT"(Cochran-Armitage trend test)}
}
\value{
data.frame with pvalue and estimate
}
\description{
Do difference analysis of gene level copy number variation data
}
\examples{
\donttest{
# use TCGAbiolinks data as example
library(TCGAbiolinks)
query <- GDCquery(
        project = "TCGA-ACC",
        data.category = "Copy Number Variation",
        data.type = "Gene Level Copy Number",
        access = "open"
)
GDCdownload(query)
cnvData <- GDCprepare(query)
aa <- assays(cnvData)$copy_number
bb <- aa
aa[bb == 2] <- 0
aa[bb < 2] <- -1
aa[bb > 2] <- 1
sampleGroup <- sample(c("A", "B"), ncol(cnvData), replace = TRUE)
diffCnv <- differential_CNV(aa, sampleGroup)

# Use sangerbox CNV data as example
cnvData <- fread("Merge_GeneLevelCopyNumber.txt")
class(cnvData) <- "data.frame"
rownames(cnvData) <- cnvData[, 1]
cnvData <- cnvData[, -c(1, 2, 3)]
sampleGroup <- sample(c("A", "B"), ncol(cnvData), replace = TRUE)
diffCnv <- differential_CNV(cnvData, sampleGroup)
}
# use random data as example
aa <- matrix(sample(c(0, 1, -1), 200, replace = TRUE), 25, 8)
rownames(aa) <- paste0("gene", 1:25)
colnames(aa) <- paste0("sample", 1:8)
sampleGroup <- sample(c("A", "B"), ncol(aa), replace = TRUE)
diffCnv <- differential_CNV(aa, sampleGroup)
}
