% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NanoStringGeoMxSet-qc.R
\name{setQCFlags,NanoStringGeoMxSet-method}
\alias{setQCFlags,NanoStringGeoMxSet-method}
\title{Add QC flags to feature and protocol data simultaneously}
\usage{
\S4method{setQCFlags}{NanoStringGeoMxSet}(object, qcCutoffs = DEFAULTS, ...)
}
\arguments{
\item{object}{name of the object class to perform QC on
\enumerate{
    \item{NanoStringGeoMxSet, use the NanoStringGeoMxSet class}
}}

\item{qcCutoffs}{list of cutoffs and thresholds to use for QC}

\item{...}{optional parameters to pass}
}
\value{
the object that QC was performed on
}
\description{
Add QC flags to feature and protocol data simultaneously
}
\examples{
datadir <- system.file("extdata", "DSP_NGS_Example_Data",
                       package="GeomxTools")
demoData <- readRDS(file.path(datadir, "/demoData.rds"))
setQCFlags(demoData[,1:10])

}
