% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epitope.R
\name{addSequenceAnnotations}
\alias{addSequenceAnnotations}
\title{Add Sequence Annotations for Epitopes}
\usage{
addSequenceAnnotations(eds)
}
\arguments{
\item{eds}{HERONEpitopeDataSet with probe_meta in metadata()}
}
\value{
HERONEpitopeDataSet with the rowData() set with sequence annotations
}
\description{
Add Sequence Annotations for Epitopes
}
\examples{
data(heffron2021_wuhan)
pval_seq_res <- calcCombPValues(heffron2021_wuhan)
pval_pr_res <- convertSequenceDSToProbeDS(pval_seq_res)
calls_res <- makeProbeCalls(pval_pr_res)
segments_res <- findEpitopeSegments(calls_res, "unique")
epval_res <- calcEpitopePValues(calls_res, segments_res)
epval_res <- addSequenceAnnotations(epval_res)
}
