% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichfind_cpx.R
\name{enrichfind_cpx}
\alias{enrichfind_cpx}
\title{Functional Enrichment Analysis for Predicted Modules}
\usage{
enrichfind_cpx(
  predcpx,
  threshold = 0.05,
  sources = c("GO", "KEGG"),
  p.corrction.method = "bonferroni",
  org = "hsapiens"
)
}
\arguments{
\item{predcpx}{Predicted modules resutled from
\code{\link[HPiP]{run_clustering}}.}

\item{threshold}{Custom p-value threshold for significance.}

\item{sources}{A vector of data sources to use.
See \code{\link[gprofiler2]{gost}} for more details.}

\item{p.corrction.method}{The algorithm used for multiple testing
correction;defaults to 'bonferroni'.
See \code{\link[gprofiler2]{gost}} for more details.}

\item{org}{An organism name;defaults to 'hsapiens'.
See \code{\link[gprofiler2]{gost}} for more details.}
}
\value{
A data.frame with the enrichment analysis results.
}
\description{
This function uses \code{\link[gprofiler2]{gost}} function
in \code{gprofiler2} package to perfrom functional enrichment analysis
for predicted modules.
}
\details{
enrichfind_cpx
}
\author{
Matineh Rahmatbakhsh, \email{matinerb.94@gmail.com}
}
