% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_positivePPI.R
\name{get_positivePPI}
\alias{get_positivePPI}
\title{Fetch Positive Reference Host-Pathogen Protein-Protein
Interactions (HP-PPIs) from the BioGRID Database}
\usage{
get_positivePPI(
  organism.taxID,
  access.key,
  filename = "PositiveInt.RData",
  path = "PositiveInt"
)
}
\arguments{
\item{organism.taxID}{Taxonomy identifier for the pathogen.}

\item{access.key}{Access key for using BioGRID webpage. To retrieve
interactions from the BioGRID database, the users are first required to
register for access key at
\url{https://webservice.thebiogrid.org/}.}

\item{filename}{A character string, indicating the output filename as an
RData object to store the retrieved interactions.}

\item{path}{A character string indicating the path to the project
directory that contains the interaction data. If the directory is
missing, it will be stored in the current directory.
Default is PositiveInt.}
}
\value{
A Data.frame containing true positive protein-protein
interactions for the selected pathogen.
}
\description{
This function retrieves positive reference host-pathogen
protein-protein interactions directly from BioGRID database.
}
\details{
get_positivePPI
}
\examples{
\donttest{
local = tempdir()
try(get_positivePPI(organism.taxID = 2697049,
access.key = 'XXXX',
filename = "PositiveInt.RData",
path = local))
}
}
\seealso{
See \code{\link{get_negativePPI}} for generating negative
protein-protein interaction.
}
\author{
Matineh Rahmatbakhsh, \email{matinerb.94@gmail.com}
}
