% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute_missing_data.R
\name{impute_missing_data}
\alias{impute_missing_data}
\title{Impute missing Values per Features (i.e., Columns)}
\usage{
impute_missing_data(x, method = c("mean", "median", "zero"))
}
\arguments{
\item{x}{A numeric matrix as input.}

\item{method}{Imputation method for missing values
(mean, median or zero).}
}
\value{
Imputed matrix.
}
\description{
Given an input matrix, impute the missing values
via three approaches including mean, median or zero.
}
\details{
impute_missing_data
}
\examples{
x <- matrix(1:10, ncol = 2)
x[1:3, 2] <- NA
row.names(x) <- c("A", "B", "C", "D", "E")
colnames(x) <- c("col1", "col2")
impute_missing_data(x, method = "mean")
impute_missing_data(x, method = "median")
impute_missing_data(x, method = "zero")
}
\author{
Matineh Rahmatbakhsh \email{matinerb.94@gmail.com}
}
