% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pred_ensembel.R
\name{pred_ensembel}
\alias{pred_ensembel}
\title{Predict Interactions via Ensemble Learning Method}
\usage{
pred_ensembel(
  features,
  gold_standard,
  classifier = c("avNNet", "svmRadial", "ranger"),
  resampling.method = "cv",
  ncross = 2,
  repeats = 2,
  verboseIter = TRUE,
  plots = TRUE,
  filename = "plots.pdf"
)
}
\arguments{
\item{features}{A data frame with host-pathogen protein-protein
interactions (HP-PPIs) in the first column, and features to be passed to
the classifier in the remaining columns.}

\item{gold_standard}{A data frame with gold_standard HP-PPIs and class
label indicating if such PPIs are positive or negative.}

\item{classifier}{The type of classifier to use. See \code{caret}
for the availbale classifiers.}

\item{resampling.method}{The resampling method:'boot', 'boot632',
'optimism_boot', boot_all', 'cv', 'repeatedcv', 'LOOCV', 'LGOCV';
defaults to cv. See \code{\link[caret]{trainControl}} for more details.}

\item{ncross}{Number of partitions for cross-validation;
defaults to 5.See \code{\link[caret]{trainControl}} for more details.}

\item{repeats}{for repeated k-fold cross validation only;
defaults to 3.See \code{\link[caret]{rfeControl}}
for more details.}

\item{verboseIter}{Logical value, indicating whether to check the status
of training process;defaults to FALSE.}

\item{plots}{Logical value, indicating whether to plot the performance
of ensemble learning algorithm as compared to individual classifiers;
defaults to TRUE.If the argument set to TRUE, plots will be saved in
the current working directory.
These plots are :
\itemize{
\item{pr_plot} - Precision-recall plot of ensemble classifier vs
selected individual classifiers.
\item{roc_plot} - ROC plot of ensemble classifier vs selected individual
classifiers.
\item{points_plot} - Plot accuracy, F1-score ,positive predictive value
(PPV),sensitivity (SE), and Matthews correlation coefficient (MCC) of
ensemble classifier vs selected individual classifiers.
}}

\item{filename}{A character string, indicating the output filename as an
pdf object.}
}
\value{
Ensemble_training_output
\itemize{
\item{prediction score} - Prediction scores for whole dataset from each
individual classifier.
\item{Best} - Selected hyper parameters.
\item{Parameter range} - Tested hyper parameters.
\item{prediction_score_test} - Scores probabilities for test data from
each individual classifier.
\item{class_label} -  Class probabilities for test data from each
individual classifier.
}
classifier_performance
\itemize{
\item{cm} - A confusion matrix.
\item{ACC} - Accuracy.
\item{SE} - Sensitivity.
\item{SP} - Specificity.
\item{PPV} - Positive Predictive Value.
\item{F1} - F1-score.
\item{MCC} - Matthews correlation coefficient.
\item{Roc_Object} - A list of elements.
See \code{\link[pROC]{roc}} for more details.
\item{PR_Object} - A list of elements.
See \code{\link[PRROC]{pr.curve}} for more details.
}
predicted_interactions - The input data frame of pairwise interactions,
including classifier scores averaged across all models.
}
\description{
This function uses an ensemble of classifiers to
predict interactions from the sequence-based dataset. This ensemble
algorithm combines different results generated from individual
classifiers within the ensemble via average to enhance prediction.
}
\details{
pred_ensembel
}
\examples{
data('example_data')
features <- example_data[, -2]
gd <- example_data[, c(1,2)]
gd <- na.omit(gd)
ppi <-pred_ensembel(features,gd,
classifier = c("avNNet", "svmRadial", "ranger"),
resampling.method = "cv",ncross = 2,verboseIter = FALSE,plots = FALSE,
filename = "plots.pdf")
#extract predicted interactions
pred_interaction <- ppi[["predicted_interactions"]]
}
\author{
Matineh Rahmatbakhsh, \email{matinerb.94@gmail.com}
}
