% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Brick_functions.R
\name{Brick_fetch_range_index}
\alias{Brick_fetch_range_index}
\title{Returns the position of the supplied ranges in the binning table
associated to the Hi-C experiment.}
\usage{
Brick_fetch_range_index(
    Brick = NA,
    chr = NA,
    start = NA,
    end = NA,
    names = NA,
    resolution = NA,
    type = "any"
)
}
\arguments{
\item{Brick}{\strong{Required}.
A string specifying the path to the Brick store created with
Create_many_Brick.}

\item{chr}{\strong{Required}.
A character vector of length N specifying the chromosomes to select from
the ranges.}

\item{start}{\strong{Required}.
A numeric vector of length N specifying the start positions in the
chromosome}

\item{end}{\strong{Required}.
A numeric vector of length N specifying the end positions in the chromosome}

\item{names}{\strong{Optional}.
A character vector of length N specifying the names of the chromosomes. If
absent, names will take the form chr:start:end.}

\item{resolution}{\strong{Optional}. Default NA
When an object of class BrickContainer is provided, resolution defines the
resolution on which the function is executed}

\item{type}{\strong{Optional}. Default any
Type of overlap operation to do. It should be one of two, any or within.
any considers any overlap (atleast 1 bp) between the provided ranges and
the binning table.}
}
\value{
Returns a GenomicRanges object of same length as the chr, start, end
vectors provided. The object is returned with an additional column, Indexes.
Indexes is a column of class \code{IRanges::IntegerList}, which is
part of the larger \code{IRanges::AtomicList} superset. This
"Indexes" column can be accessed like a normal GRanges column with the
additional list accessor [[]] in place of the normal vector accessor [].
}
\description{
\code{Brick_fetch_range_index} constructs a ranges object using
\code{\link{Brick_make_ranges}}, creates an overlap operation using
\code{GenomicRanges::findOverlaps}, where the constructed ranges is
the \emph{subject} and the Hi-C experiment associated binning table is the
\emph{query}. The return of this object is a list of ranges with their
corresponding indices in the binning table.
}
\examples{

Bintable.path <- system.file(file.path("extdata", "Bintable_100kb.bins"), 
package = "HiCBricks")

out_dir <- file.path(tempdir(), "fetch_range_index_test")
dir.create(out_dir)

My_BrickContainer <- Create_many_Bricks(BinTable = Bintable.path, 
  bin_delim = " ", output_directory = out_dir, file_prefix = "Test",
  experiment_name = "Vignette Test", resolution = 100000,
  remove_existing = TRUE)

Chrom <- c("chr2L","chr2L")
Start <- c(1,40000)
End <- c(1000000,2000000)

Test_Run <- Brick_fetch_range_index(Brick = My_BrickContainer, 
chr = Chrom, start = Start, end = End, resolution = 100000)
Test_Run$Indexes[[1]]

}
