% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HTClist2gi_list.R
\name{HTClist2gi_list}
\alias{HTClist2gi_list}
\title{HTClist2gi_list}
\usage{
HTClist2gi_list(htc_list, chrs = NULL, Dthreshold = 2e+06)
}
\arguments{
\item{htc_list}{A valid HTClist instance (see \code{vignette("HiTC")})}

\item{chrs}{select a subset of chromosomes' e.g.,
c('chr21','chr22'). Defaults to chromosomes in \code{htc_list}.}

\item{Dthreshold}{maximum distance (included) to check for significant
interactions, defaults to 2e6 or maximum in the data; whichever is smaller.}
}
\value{
a thresholded gi_list instance with intra-chromosomal counts for
further use with HiCDCPlus
}
\description{
This function converts a HTClist instance into a gi_list instance with counts
for further use with this package, HiCDCPlus
}
\examples{
gi_list<-generate_binned_gi_list(50e3,chrs=c('chr22'))
gi_list<-add_hic_counts(gi_list,
hic_path=system.file("extdata", "GSE63525_HMEC_combined_example.hic",
package = "HiCDCPlus"))
htc_list<-gi_list2HTClist(gi_list)
gi_list2<-HTClist2gi_list(htc_list,Dthreshold=Inf)
}
