% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotInteractions.R
\name{plotInteractions}
\alias{plotInteractions}
\title{Plot interaction matrices.}
\usage{
plotInteractions(
  object,
  chromosome,
  transform = NULL,
  colours = c(low = "#2c7bb6", mid = "#ffffbf", high = "#d7191c"),
  midpoint = 0
)
}
\arguments{
\item{object}{A \code{\link{HiCDOCDataSet}}.}

\item{chromosome}{A chromosome name or index in \code{chromosomes(object)}.}

\item{transform}{Transformation of the color scale. Default to NULL (no transformation). See
\code{\link[ggplot2]{scale_fill_gradient2}} for other accepted values.}

\item{colours}{A character vector colours of length 3 to use for the gradient. See
\code{\link[ggplot2]{scale_fill_gradient2}} for more info. Defaults to
\code{c("low"=#2c7bb6", "mid"=#ffffbf", "high"="#d7191c")}.}

\item{midpoint}{midpoint value to be passed to \code{scale_fill_gradient2}.
Default to 0.}
}
\value{
A \code{ggplot}.
}
\description{
Plots the interaction matrices as heatmaps.
}
\examples{
data(exampleHiCDOCDataSet)
plotInteractions(exampleHiCDOCDataSet, chromosome = 1)

}
