% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSelfInteractionRatios.R
\name{plotSelfInteractionRatios}
\alias{plotSelfInteractionRatios}
\title{Plot boxplots of self interaction ratios.}
\usage{
plotSelfInteractionRatios(object, chromosome, checks = TRUE)
}
\arguments{
\item{object}{A \code{\link{HiCDOCDataSet}}.}

\item{chromosome}{A chromosome name or index in \code{chromosomes(object)}.
A \code{\link{HiCDOCDataSet}}.}

\item{checks}{Logical. Should sanity checks messages be printed on plot ? Default to TRUE.}
}
\value{
A \code{ggplot}.
}
\description{
Plots the boxplots of self interaction ratios, which are the differences
between self interaction and median of other interactions for each genomic
position. Since the A compartment is open with more interactions overall, it
is assumed that self interaction ratios in compartment A are smaller than in
compartment B.
}
\examples{
data(exampleHiCDOCDataSetProcessed)
plotSelfInteractionRatios(exampleHiCDOCDataSetProcessed, chromosome = 1)

}
