% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoreMethods.R
\name{HierarchicalClustering}
\alias{HierarchicalClustering}
\alias{HierarchicalClustering.SingleCellExperiment}
\alias{HierarchicalClustering,SingleCellExperiment-method}
\title{Hierarchical clustering using the Ward's method}
\usage{
HierarchicalClustering.SingleCellExperiment(object)

\S4method{HierarchicalClustering}{SingleCellExperiment}(object)
}
\arguments{
\item{object}{of \code{SingleCellExperiment} class}
}
\value{
object of \code{SingleCellExperiment} class
}
\description{
Perform Hierarchical clustering using the Ward's method.
}
\examples{
library(SingleCellExperiment)
sce <- SingleCellExperiment(assays = list(logcounts = pbmc3k_500))
sce <- PrepareILoReg(sce)
## These settings are just to accelerate the example, use the defaults.
sce <- RunParallelICP(sce,L=2,threads=1,C=0.1,k=5,r=1)
sce <- RunPCA(sce,p=5)
sce <- HierarchicalClustering(sce)

}
\keyword{clustering}
\keyword{hierarchical}
\keyword{ward}
