% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoreMethods.R
\name{RunPCA}
\alias{RunPCA}
\alias{RunPCA.SingleCellExperiment}
\alias{RunPCA,SingleCellExperiment-method}
\title{PCA transformation of the joint probability matrix}
\usage{
RunPCA.SingleCellExperiment(object, p, scale, threshold)

\S4method{RunPCA}{SingleCellExperiment}(object, p = 50, scale = FALSE, threshold = 0)
}
\arguments{
\item{object}{object of \code{SingleCellExperiment} class}

\item{p}{a positive integer denoting the number of principal
components to calculate and select. Default is \code{50}.}

\item{scale}{a logical specifying whether the probabilities should be
standardized to unit-variance before running PCA. Default is \code{FALSE}.}

\item{threshold}{a thresfold for filtering out ICP runs before PCA with
the lower terminal projection accuracy below the threshold.
Default is \code{0}.}
}
\value{
object of \code{SingleCellExperiment} class
}
\description{
Perform the PCA transformation of the joint probability matrix,
which reduces the dimensionality from k*L to p
}
\examples{
library(SingleCellExperiment)
sce <- SingleCellExperiment(assays = list(logcounts = pbmc3k_500))
sce <- PrepareILoReg(sce)
## These settings are just to accelerate the example, use the defaults.
sce <- RunParallelICP(sce,L=2,threads=1,C=0.1,k=5,r=1)
sce <- RunPCA(sce,p=5)


}
\keyword{PCA}
\keyword{eigendecomposition}
