% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoreMethods.R
\name{SilhouetteCurve}
\alias{SilhouetteCurve}
\alias{SilhouetteCurve.SingleCellExperiment}
\alias{SilhouetteCurve,SingleCellExperiment-method}
\title{Silhouette curve}
\usage{
SilhouetteCurve.SingleCellExperiment(object, return.plot)

\S4method{SilhouetteCurve}{SingleCellExperiment}(object, return.plot = FALSE)
}
\arguments{
\item{object}{of \code{SingleCellExperiment} class}

\item{return.plot}{a logical denoting whether the ggplot2 object
should be returned. Default is \code{FALSE}.}
}
\value{
ggplot2 object if return.plot=TRUE
}
\description{
Draw the silhouette curve: the average silhouette value across
the cells for a range of different K values.
}
\examples{
library(SingleCellExperiment)
sce <- SingleCellExperiment(assays = list(logcounts = pbmc3k_500))
sce <- PrepareILoReg(sce)
## These settings are just to accelerate the example, use the defaults.
sce <- RunParallelICP(sce,L=2,threads=1,C=0.1,k=5,r=1)
sce <- RunPCA(sce,p=5)
sce <- HierarchicalClustering(sce)
sce <- CalcSilhInfo(sce)
SilhouetteCurve(sce)

}
\keyword{clustering}
\keyword{hierarchical}
\keyword{ward}
