% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/newINSPEcT-functions.R
\name{newINSPEcT}
\alias{newINSPEcT}
\title{Create a new INSPEcT object}
\usage{
newINSPEcT(
  tpts,
  labeling_time = NULL,
  nascentExpressions = NULL,
  matureExpressions,
  preexisting = FALSE,
  BPPARAM = SerialParam(),
  labeledSF = NULL,
  simulatedData = FALSE,
  degDuringPulse = FALSE,
  Dmin = 1e-06,
  Dmax = 10,
  genesFilter = TRUE,
  genesFilterThreshold = 2/3,
  imputeNAs = TRUE
)
}
\arguments{
\item{tpts}{A vector of time points, one for each sample}

\item{labeling_time}{A number, lenght of the Nascent pulse}

\item{nascentExpressions}{A list which contains exons and introns expression matrices and variances for the nascent RNA}

\item{matureExpressions}{A list which contains exons and introns expression matrices and variances for the mature RNA}

\item{preexisting}{A logical, indicating if the mature expression refers to the pre-exising (unlabeled) population. Not implemented yet for the "degDuringPulse" mode.}

\item{BPPARAM}{Configuration for BiocParallel parallelization. By default is set to SerialParam()}

\item{labeledSF}{A vector storing user defined normalization scale over Nascent RNA exons and introns quantifications}

\item{simulatedData}{A logical, set to TRUE in case the analysis is on simulated data}

\item{degDuringPulse}{A logical, set to TRUE in case of a long labelling time. Also degradation of newly synthesized transcripts will be taken into account}

\item{Dmin}{A numerical, it is the lower bound of the degradation rate domain for the prior optimization}

\item{Dmax}{A numerical, it is the upper bound of the degradation rate domain for the prior optimization}

\item{genesFilter}{A logical, if TRUE, filters out genes which have no signal in at least a given fraction (2/3 by default) of the observations}

\item{genesFilterThreshold}{A number, threshold to use for genes filtering (2/3 by default)}

\item{imputeNAs}{A logical, if TRUE the rates first guess which are not finite are imputed from the neighbours.}
}
\value{
An object of class INSPEcT with a first estimation of the rates which can be accessed by the method \code{\link{ratesFirstGuess}}
}
\description{
The function newINSPEcT creates a new instance of the class INSPEcT provided the experimental time points, expression data (like RPKMs) of mature
and eventually nascent RNA. For the nascent analysis, it is also requires a collecting time and the scaling factor to
normalize the nascent RNA-seq libraries. This latter parameter can also be calculated by the function itself if both exonic and intronic
expression data are provided; otherwise it must be given as an input and it is essential to guarantee the robustness of the analysis.
}
\examples{
data('allcounts', package='INSPEcT')
data('featureWidths', package='INSPEcT')
data('libsizes', package='INSPEcT')

matureCounts<-allcounts$mature
tpts <- c(0,1/6,1/3,1/2,1,1.5,2,4,8,12,16)
expDes<-rep(tpts,3)

matExp_DESeq2<-quantifyExpressionsFromTrCounts(
 	allcounts=matureCounts
 	,libsize=totalLS
 	,exonsWidths=exWdths
 	,intronsWidths=intWdths
 	,experimentalDesign=expDes)

matureInspObj<-newINSPEcT(tpts=tpts
                         ,labeling_time=NULL
                         ,nascentExpressions=NULL
                         ,matureExpressions=matExp_DESeq2)
}
