% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Extract-methods.R
\docType{methods}
\name{split}
\alias{split}
\alias{split,INSPEcT,ANY-method}
\title{Divide an INSPEcT Object into groups}
\usage{
\S4method{split}{INSPEcT,ANY}(x, f, drop = FALSE, ...)
}
\arguments{
\item{x}{An object of class INSPEcT}

\item{f}{A vector of length equal to the number of genes in x which defines the groups}

\item{drop}{A logical belonging to the generic funciton, useless in this context.}

\item{...}{Additional arguments to match the generic function}
}
\value{
A list containing objects of class INSPEcT
}
\description{
Divides the INSPEcT object into the groups defined by 'f',
}
\examples{
nascentInspObj10 <- readRDS(system.file(package='INSPEcT', 'nascentInspObj10.rds'))
splitIdx <- c(1,1,1,2,2,2,3,3,3,4)
nascentInspObj10Split <- split(nascentInspObj10, splitIdx)
}
