% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/14.adjust_distalCPs.R
\name{adjust_distalCPs}
\alias{adjust_distalCPs}
\title{Adjust distal CP sites by the cleanUpdTSeq algorithm}
\usage{
adjust_distalCPs(
  distalCPs,
  classifier,
  classifier_cutoff,
  shift_range,
  genome,
  seqname,
  step = 1
)
}
\arguments{
\item{distalCPs}{the output of \code{\link[=search_distalCPs]{search_distalCPs()}}}

\item{classifier}{An R object for Naive Bayes classifier model, like the one
in the cleanUpdTSeq package.}

\item{classifier_cutoff}{A numeric(1) vector. A cutoff of probability that a
site is classified as true CP sites. The value should be between 0.5 and 1.
Default, 0.8.}

\item{shift_range}{An integer(1) vector, specifying a shift range for
adjusting the proximal and distal CP sites. Default, 50. It determines the
range flanking the candidate CP sites to search the most likely CP sites.}

\item{genome}{a \link[BSgenome:BSgenome-class]{BSgenome::BSgenome} object}

\item{seqname}{A character(1) vector, specifying a chromososome/scaffold name}

\item{step}{An integer (1) vector, specifying the step size used for adjusting
the proximal or distal CP sites using the Naive Bayes classifier from the
cleanUpdTSeq package. Default 1. It can be in the range of 1 to 5.}
}
\description{
Adjust distal CP sites by the cleanUpdTSeq algorithm
}
\seealso{
\code{\link[=search_proximalCPs]{search_proximalCPs()}}, \code{\link[=get_PAscore2]{get_PAscore2()}}
}
\author{
Jianhong Ou
}
\keyword{internal}
