% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/information.plugin.R
\name{MI.plugin}
\alias{MI.plugin}
\title{A plug-in calculator for evaluating mutual information}
\usage{
MI.plugin(probs, unit = c("log", "log2", "log10"))
}
\arguments{
\item{probs}{the joint probability distribution table of two random variables.}

\item{unit}{the base of the logarithm. The default is natural logarithm, which is "log".
For evaluating entropy in bits, it is suggested to set the unit to "log2".}
}
\value{
MI.plugin returns the mutual information.
}
\description{
MI.plugin measures the mutual information between two random variables from the joint probability distribution table.
}
\examples{
# two numeric vectors corresponding to two continuous random variables
x <- c(0.0, 0.2, 0.2, 0.7, 0.9, 0.9, 0.9, 0.9, 1.0)
y <- c(1.0, 2.0,  12, 8.0, 1.0, 9.0, 0.0, 3.0, 9.0)

# corresponding joint count table estimated by "uniform width" algorithm
count_xy <- discretize2D(x, y, "uniform_width")

# the joint probability distribution table of the count data
library("entropy")
probs_xy <- freqs.empirical(count_xy)

# corresponding mutual information
MI.plugin(probs_xy)
}
