% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input_data.R
\name{input_data}
\alias{input_data}
\title{Load and process input data}
\usage{
input_data(SE, path_to_tpm = NULL)
}
\arguments{
\item{SE}{a \code{SummarizedExperiment} object created by \code{\link{generate_SE}} function.
Alternatively, this object can be created by the user, following the structure
specified in the "Input user-provided data" Section of the vignettes}

\item{path_to_tpm}{(optional) a \code{data.frame} object or a character string
indicating the path to a tsv file with mRNA isoform TPMs.
The tsv file must have 1 row per isoform, and 2 columns:
i) 'isoname': a character string indicating the isoform name;
ii) 'tpm': a numeric variable indicating
the Transcripts Per Million (TPM) count.
Column names must be 'isoname' and 'tpm'.}
}
\value{
A \code{list} of \code{data.frame} objects, with the data needed
to run \code{\link{inference}} function.
}
\description{
\code{input_data} reads and processes a \code{SummarizedExperiment} object collecting
input data and metadata required to run IsoBayes model.
}
\examples{
# Load internal data to the package:
data_dir = system.file("extdata", package = "IsoBayes")

# Define the path to the AllPeptides.psmtsv file returned by *MetaMorpheus* tool
path_to_peptides_psm = paste0(data_dir, "/AllPeptides.psmtsv")

# Generate a SummarizedExperiment object
SE = generate_SE(path_to_peptides_psm = path_to_peptides_psm,
                 abundance_type = "psm",
                 input_type = "metamorpheus"
                 )
# Load and process SE object
data_loaded = input_data(SE)

# For more examples see the vignettes:
# browseVignettes("IsoBayes")

}
\seealso{
\code{\link{generate_SE}}, \code{\link{inference}}
}
\author{
Jordy Bollon \email{jordy.bollon@iit.it}
and Simone Tiberi \email{simone.tiberi@unibo.it}
}
