% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clonalMutationCounter.R
\name{clonalMutationCounter}
\alias{clonalMutationCounter}
\title{Count clonal mutations on one or several chromosomal copies}
\usage{
clonalMutationCounter(
  nbObj = NULL,
  min.cn = 1,
  max.cn = 4,
  chromosomes = seq_len(22)
)
}
\arguments{
\item{nbObj}{combined SNV and CNV information as generated by
\code{\link{nbImport}}.}

\item{min.cn}{minimal copy number.}

\item{max.cn}{maximal copy number.}

\item{chromosomes}{the chromosomes to be evaluated.}
}
\value{
a data table reporting the length of each segment, the number of
clonal mutations on all A-allele copies, the number of clonal mutations on
all B-allele copies and the total number of clonal mutations (including
clonal mutations on a single copy only).
}
\description{
This function counts the number of clonal mutations residing on a single or
multiple copies per genomic segment. Segments of equal copy number and
B-allele count are merged per chromosome.
}
\examples{
snvs <- system.file("extdata", "NBE15",
    "snvs_NBE15_somatic_snvs_conf_8_to_10.vcf",
    package = "LACHESIS"
)
s_data <- readVCF(vcf = snvs, vcf.source = "dkfz")
aceseq_cn <- system.file("extdata", "NBE15",
    "NBE15_comb_pro_extra2.51_1.txt",
    package = "LACHESIS"
)
c_data <- readCNV(aceseq_cn)
nb <- nbImport(cnv = c_data, snv = s_data, purity = 1, ploidy = 2.51)
cl_muts <- clonalMutationCounter(nb)
}
