% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMutationDensities.R
\name{plotMutationDensities}
\alias{plotMutationDensities}
\title{Plot normalized mutation density at copy number gain and MRCA per segment}
\usage{
plotMutationDensities(
  mrcaObj = NULL,
  samp.name = NULL,
  min.seg.size = 10^7,
  ref.build = "hg19",
  mut.col.zero = "#4FB12B",
  mut.col.multi = "#176A02",
  mut.border = NULL,
  mut.show.density = TRUE,
  mut.breaks = NULL,
  mut.xaxis = NULL,
  mut.show.realtime = FALSE,
  mut.snv.rate = 3.2,
  output.file = NULL,
  ...
)
}
\arguments{
\item{mrcaObj}{output generated from \code{\link{MRCA}}}

\item{samp.name}{sample name, optional}

\item{min.seg.size}{minimal segment size to plot}

\item{ref.build}{Reference genome. Default \code{hg19}.
Can be \code{hg18}, \code{hg19} or \code{hg38}.}

\item{mut.col.zero}{optional, the bar color for densities of mutations
present on single copies.}

\item{mut.col.multi}{optional, the bar color for densities of mutations
present on multiple copies.}

\item{mut.border}{optional, the line color}

\item{mut.show.density}{optional; if \code{TRUE}, the density distribution of
mutation densities on single copies will be shown in the histogram of
mutation densities on multiple copies.}

\item{mut.breaks}{optional; the number of bins in the histogram.}

\item{mut.xaxis}{optional; cutoff value for x-axis in evolutionary timeline
plot in SNVs/Mb}

\item{mut.show.realtime}{logical; if \code{TRUE}, displays weeks post-conception
on the evolutionary timeline.}

\item{mut.snv.rate}{optional; rate of accumulated SNVs per day in a
diploid genome (i.e. 3.2 SNVs/day in neuroblastoma)}

\item{output.file}{optional; will save the plot.}

\item{...}{further arguments and parameters passed to other
LACHESIS functions.}
}
\value{
graphs with mutation densitiy at ECA and MRCA as well as
evolutionary timeline plot
}
\description{
Visualizes results from \code{\link{MRCA}}. Top plot, histograms of mean
mutation densities; bottom plots, timeline of early tumor evolution,
showing mutation densities (mean and 95\% CI) of individual chromosomal gains
and mutation densities at ECA and MRCA.
}
\examples{
snvs <- system.file("extdata", "NBE15",
    "snvs_NBE15_somatic_snvs_conf_8_to_10.vcf",
    package = "LACHESIS"
)
s_data <- readVCF(vcf = snvs, vcf.source = "dkfz")
aceseq_cn <- system.file("extdata", "NBE15",
    "NBE15_comb_pro_extra2.51_1.txt",
    package = "LACHESIS"
)
c_data <- readCNV(aceseq_cn)
nb <- nbImport(cnv = c_data, snv = s_data, purity = 1, ploidy = 2.51)
cl_muts <- clonalMutationCounter(nb)
norm_muts <- normalizeCounts(cl_muts)
mrca <- MRCA(norm_muts)
plotMutationDensities(mrca)
}
