% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_markergenes}
\alias{get_markergenes}
\title{Get top marker genes for each subcluster}
\usage{
get_markergenes(enriched.g, method = c("LR", "LiR"), topn = 100)
}
\arguments{
\item{enriched.g}{A return from \link[LRcell]{LRcell_gene_enriched_scores}
or from provided data}

\item{method}{If LR, the return will be a list of genes; If LiR, the return
will be a list of named vector with names as genes and values as enriched
scores.}

\item{topn}{Top N genes as marker genes.}
}
\value{
A list of top marker genes.
}
\description{
Get top marker genes for each subcluster
}
\examples{
library(ExperimentHub)
eh <- ExperimentHub::ExperimentHub()
eh <- query(eh, "LRcellTypeMarkers")
# eh$title
enriched_genes <- eh[['EH4548']]
marker.g <- get_markergenes(enriched_genes, method="LR", topn=100)
}
