% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LinearRegression.R
\name{LinearRegressionFP}
\alias{LinearRegressionFP}
\title{One Pass Linear Regression with fixed point.}
\usage{
LinearRegressionFP(x, y, x1, y1)
}
\arguments{
\item{x}{Numeric vector. x values.}

\item{y}{Numeric vector. corresponding y values.}

\item{x1}{Numeric. x coordinate of the fixed point.}

\item{y1}{Numeric. y coordinate of the fixed point.}
}
\value{
This function returns a list with one object, "coefficients". The first element in this object is c; the second element is m in the y = mx + c equation.
}
\description{
This function performs Linear Regression on the input data with a fixed point. It uses a one pass algorithm implemented in C++. This is for users who only need m and c from the y=mx + c equation. Compared to the lm function, this function is much faster.
}
\details{
This function calculates m and c in the linear equestion, y = mx + c.
}
\examples{
x <- 1:10
y <- 1:10
x1 <- 1
y1 <- 2
results <- LinearRegressionFP(x,y, x1, y1)
m <- results$coefficients[[2]]
c <- results$coefficients[[1]]
}
\keyword{Linear}
\keyword{Regression}
\keyword{constant}
\keyword{slope}
