% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotRegion2D.R
\name{plotRegion2D}
\alias{plotRegion2D}
\alias{plotRegion2D,LipidTrendSE-method}
\title{Plot region trends for two-dimensional lipid features}
\usage{
plotRegion2D(object, p_cutoff = 0.05, log2FC_cutoff = 3)

\S4method{plotRegion2D}{LipidTrendSE}(object, p_cutoff = 0.05, log2FC_cutoff = 3)
}
\arguments{
\item{object}{A LipidTrendSE object generated by \code{analyzeLipidRegion()}
for two-dimensional analysis.}

\item{p_cutoff}{Numeric. Significance threshold for smoothed permutation
p-values. Default is \code{0.05}.}

\item{log2FC_cutoff}{Numeric. Threshold for absolute log2 fold-change used to
truncate the color scale in the heatmap. Values exceeding this threshold
will be capped at the cutoff value for visualization purposes. Default is
\code{3}.}
}
\value{
If \code{split_chain=TRUE} in the analysis, the function returns a list with:
\enumerate{
\item{even_result: A ggplot object for even-chain lipids,
or \code{NULL} if none exist.}
\item{odd_result: A ggplot object for odd-chain lipids, or \code{NULL}
if none exist.}
}
If \code{split_chain=FALSE}, the function returns a single ggplot object
visualizing all lipids together.
}
\description{
Visualize lipid trend analysis results in two-dimensional
feature space (e.g., chain length vs. double bond count). The resulting
heatmap highlights regions with significant trends between groups based on
the smoothed permutation test.

Each point in the heatmap represents a lipid defined by two continuous
features (such as chain length and double bond). Color indicates the
log2 fold-change between groups, and asterisks denote levels of marginal
significance. If \code{abund_weight=TRUE} during analysis, the point size
reflects the mean abundance of each lipid. If \code{abund_weight=FALSE}, all
points are displayed with equal size.
}
\examples{
data("lipid_se_2D")
res_se <- analyzeLipidRegion(
    lipid_se=lipid_se_2D, ref_group="sgCtrl", split_chain=FALSE,
    chain_col=NULL, radius=3, own_contri=0.5, test="t.test",
    abund_weight=TRUE, permute_time=100)
plot_2D <- plotRegion2D(res_se, p_cutoff=0.05)
}
\seealso{
\code{\link{analyzeLipidRegion}} for generating the input LipidTrendSE object
}
