% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bhattacharyyaCoefficient.R
\name{bhattacharyyaCoefficient}
\alias{bhattacharyyaCoefficient}
\title{Bhattacharyya coefficient}
\usage{
bhattacharyyaCoefficient(sample1, sample2)
}
\arguments{
\item{sample1}{A data frame consisting of frequencies of antigen receptor 
sequences.  "frequencyCount" is a required column.}

\item{sample2}{A data frame consisting of frequencies of antigen receptor 
sequences.  "frequencyCount" is a required column.}
}
\value{
Returns the Bhattacharyya coefficient, a measure of the amount of 
overlap between two samples.  The value ranges from 0 to 1 where 1 indicates 
the sequence frequencies are identical in the two samples and 0 indicates no 
shared frequencies.
}
\description{
Calculates the Bhattacharyya coefficient of two samples.
}
\examples{
file.path <- system.file("extdata", "TCRB_sequencing", package = "LymphoSeq")

file.list <- readImmunoSeq(path = file.path)

productive.aa <- productiveSeq(file.list, aggregate = "aminoAcid")

bhattacharyyaCoefficient(productive.aa[["TRB_Unsorted_32"]], 
   productive.aa[["TRB_Unsorted_83"]])
}
\seealso{
\code{\link{bhattacharyyaMatrix}}
}
