% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper-methods.R
\name{computeEtFromCt}
\alias{computeEtFromCt}
\title{Compute the Et from the Ct}
\usage{
computeEtFromCt(df, column = "Ct", Cmax = 40)
}
\arguments{
\item{df}{a \code{data.frame}}

\item{column}{The name of the \code{Ct} column. A \code{character}. 'Ct' by default.}

\item{Cmax}{the maximum number of cycles performed. 40 by default.}
}
\value{
A copy of \code{df} with the 'Et' column appended
}
\description{
Computes the Et value from the Ct value in an existing data frame and returns a new data frame with the Et column appended
}
\examples{
data(vbeta)
vbeta <- computeEtFromCt(vbeta)
}
\author{
Greg Finak
}
