% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertMASTClassic.R
\name{convertMASTClassicToSingleCellAssay}
\alias{convertMASTClassicToSingleCellAssay}
\title{Convert a MASTClassic SingleCellAssay}
\usage{
convertMASTClassicToSingleCellAssay(object = NULL)
}
\arguments{
\item{object}{of class \code{SingleCellAssay} created by MASTClassic}
}
\value{
A MAST SingleCellAssay object.
}
\description{
Convert a SingleCellAssay object created with the MASTClassic package to an object recognized by the new MAST package
}
\details{
The function will extract the relevant information from the attributes of the old object and construct a new
SingleCellAssay that is recognized by MAST. This function checks that the object is a MASTClassic SingleCellAssay object. It will stop 
if it is not a SingleCellAssay, return a converted SingleCellAssay if object was created by MASTClassic, and return the original
object if the object is already compatible.
}
\note{
Type checking for old object is not performed.
}
\examples{
data(vbetaFA)
convertMASTClassicToSingleCellAssay(vbetaFA)
}
