% Generated by roxygen2 (4.0.1): do not edit by hand
\name{getSimulationPvalue}
\alias{getSimulationPvalue}
\title{Function to calculate simulations-based p-values}
\usage{
getSimulationPvalue(observedVal, simulatedVals, direction = "greater",
  checkArgs = FALSE)
}
\arguments{
\item{observedVal}{observed statistic (single number)}

\item{simulatedVals}{statistics observed in simulations of the outcomes based on assumed null distribution.}

\item{direction}{one of 'greater' or 'less', depending on the nature of statistic.}

\item{checkArgs}{single boolean specifying whether arguments should be checked for adherence to specifications. DEFAULT: FALSE}
}
\value{
a fraction of simulated statistics that are as or more extreme as the observed one
}
\description{
Function to calculate simulations-based p-values
}
\details{
this function calculates fraction of simulated values (statistics from null distribution) that are >= (direction='greater') or <= (direction='less') than the observed statistic. The choice of direction depends on the nature of the statistic (i.e., direction is 'greater' if large values of statistic indicate departure from null hypothesis, and direction is 'less' if the opposite is the case)
}
\examples{
MBASED:::getSimulationPvalue(observedVal=2, simulatedVals=1:10, direction='greater')
MBASED:::getSimulationPvalue(observedVal=2, simulatedVals=1:10, direction='less')
}

