% Generated by roxygen2 (4.0.1): do not edit by hand
\name{shiftAndAttenuateProportions}
\alias{shiftAndAttenuateProportions}
\title{Helper function to adjust proportions for pre-existing allelic bias and also to obtain estimate of proportion variance based on attenuated read counts (adding pseudocount of 0.5 to each allele in each sample).}
\usage{
shiftAndAttenuateProportions(countsMat, totalsMat, probsMat, rhosMat,
  checkArgs = FALSE)
}
\arguments{
\item{countsMat}{matrix of observed major allele counts. Each row represents a specific genomic locus, while each column represents a set of observed major allele counts across loci (in practice, multiple columns represent different outcomes of count simulations).}

\item{totalsMat}{matrix of total read counts across both alleles. The interpretation of rows and columns is the same as for countsMat.}

\item{probsMat}{matrix of underlying probabilites of observing the major allele. The interpretation of rows and columns is the same as for countsMat.}

\item{rhosMat}{matrix of dispersion parameters of beta distributions for each locus. The interpretation of rows and columns is the same as for countsMat.}

\item{checkArgs}{single boolean specifying whether arguments should be checked for adherence to specifications. DEFAULT: FALSE}
}
\value{
a list with 2 elements:
\item{propsShifted}{a 1-row marix of shifted major allele frequencies}
\item{propsShiftedVars}{a 1-row matrix of estimated variances of obtained MAF estimates}
}
\description{
Helper function to adjust proportions for pre-existing allelic bias and also to obtain estimate of proportion variance based on attenuated read counts (adding pseudocount of 0.5 to each allele in each sample).
}
\examples{
SNVCoverageTumor=sample(10:100,10) ## 2 genes with 5 loci each
SNVAllele1CountsTumor=rbinom(length(SNVCoverageTumor), SNVCoverageTumor, 0.5)
MBASED:::shiftAndAttenuateProportions(countsMat=matrix(SNVAllele1CountsTumor, ncol=2), totalsMat=matrix(SNVCoverageTumor, ncol=2), probsMat=matrix(rep(0.5, length(SNVCoverageTumor)), ncol=2),  rhosMat=matrix(rep(0, length(SNVCoverageTumor)), ncol=2))
}

