\name{oddratio}
\alias{oddratio}

\title{
Calculation of Zeta(\eqn{\zeta})
}
\description{
Zeta (\eqn{\zeta}) is used to measure homogeneity intensity of two subdatasets. If \eqn{\zeta >1}, these two subdatasets have good homogeneity; otherwise, \eqn{\zeta <1} indicates that two subdatasets have poor homogeneity (big noise).
}
\usage{
oddratio(XX, na, nb)
}

\arguments{
  \item{XX}{
count data of RNA reads generated by next generation sequencing.
}
  \item{na}{
number of replicate libraries in condition A.
}
  \item{nb}{
number of replicate libraries in condition B.
}
}
\details{
Zeta is defined as 
\deqn{\zeta=log(1+\frac{\bar{X}\sigma^2+1}{\bar{X}_A\sigma^2_A+\bar{X}_B\sigma^2_B+1})}
where \eqn{\zeta} is different from \eqn{\psi}. If two subdatasets have big a gap and good homogeneity, then \eqn{\zeta} value has much larger than 1.
 
}
\value{

\item{oddrat}{list of zeta values}

}

\references{
Yuan-De Tan Anita M. Chandler, Arindam Chaudhury, and Joel R. Neilson(2015) A Powerful Statistical Approach for Large-scale Differential Transcription Analysis. \emph{Plos One}. 2015 DOI: 10.1371/journal.pone.0123658. 
}
\author{
Yuan-De Tan
\email{tanyuande@gmail.com}
}


\seealso{
    \code{\link{pratio}}, \code{\link{mbetattest}}.
}
\examples{
XX<-matrix(NA,2,8)
XX[1,]<-c(112,122, 108,127,302, 314, 322, 328)
XX[2,]<-c(511, 230, 754, 335,771, 842, 1014,798)
#XX
#     [,1] [,2] [,3] [,4] [,5] [,6] [,7] [,8]
#[1,]  112  122  108  127  302  314  322  328
#[2,]  511  230  754  335  771  842 1014  798
oddratio(XX=XX,na=4,nb=4)

#[1] 3.9432676 0.8762017	
	
# see example in mbetattest
}
\keyword{ homogeneity }
\keyword{gap}
