% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlationMethExprs.R
\name{correlationMethExprs}
\alias{correlationMethExprs}
\title{Computes the correlation between methylation and expression}
\usage{
correlationMethExprs(
  multiset,
  meth_set_name = NULL,
  exprs_set_name = NULL,
  vars_meth = NULL,
  vars_exprs = NULL,
  sel_cpgs,
  flank = 250000,
  betas = TRUE,
  num_cores = 1,
  verbose = TRUE
)
}
\arguments{
\item{multiset}{\code{MultiDataSet} containing a \code{methylation} and an 
\code{expression} slots.}

\item{meth_set_name}{Character vector with the name of the \code{MultiDataSet}'s slot containing methylation
data.}

\item{exprs_set_name}{Character vector with the name of the \code{MultiDataSet}'s slot containing expression
data.}

\item{vars_meth}{Character vector with the names of the variables that will be
used to obtain the methylation residuals. By default, none is used and residuals 
are not computed.}

\item{vars_exprs}{Character vector with the names of the variables that will
be used to obtain the expression residuals. By default, none is used and
residuals are not computed.}

\item{sel_cpgs}{Character vector with the name of the CpGs used in the analysis. If empty, all the CpGs of the 
methylation set will be used.}

\item{flank}{Numeric with the number of pair bases used to define the cpg-expression 
probe pairs.}

\item{betas}{If \code{set} is a \code{GenomicRatioSet}, should beta values be
used? (Default: TRUE)}

\item{num_cores}{Numeric with the number of cores to be used.}

\item{verbose}{Logical value. If TRUE, it writes out some messages indicating progress. 
If FALSE nothing should be printed.}
}
\value{
Data.frame with the results of the linear regression:
\itemize{
 \item cpg: Name of the cpg
 \item exprs: Name of the expression probe
 \item beta: coefficient of the methylation change
 \item se: standard error of the beta 
 \item P.Value: p-value of the beta coefficient
 \item adj.P.Val: q-value computed using B&H
}
}
\description{
Estimates the correlation between methylation and expression. When there are known 
variables that affect methylation and/or expression, their effect can be substracted
using a linear model and then the residuals are used.
}
\details{
For each cpg, a range is defined by the position of the cpg plus the flank parameter
(upstream and downstream). Only those expression probes that are entirely in 
this range will be selected. For these reason, it is required that the \code{ExpressionSet} 
contains a featureData with the chromosome and the starting and ending positions 
of the probes.
}
