% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{SummarizedExperimentToDataTable}
\alias{SummarizedExperimentToDataTable}
\title{Make MIRA-compatible data.tables using information 
from SummarizedExperiment-based classes}
\usage{
SummarizedExperimentToDataTable(coordinates, methylCountDF = NULL,
  coverageDF = NULL, methylPropDF = NULL, sample_names = NULL)
}
\arguments{
\item{coordinates}{Coordinates for the methylation loci as a GRanges 
(or GPos) object (in same order as methylCountDF/coverageDF/methylPropDF, 
whichever is given).
The start coordinate should be the coordinate of the cytosine.}

\item{methylCountDF}{An object of matrix/data.frame/similar format
that contains the number of reads with methylated C's for the loci in
'coordinates' argument. It should have one column per sample with
rows that correspond to 'coordinates'.}

\item{coverageDF}{An object of matrix/data.frame/similar format
that contains the total number of reads for the loci in
'coordinates' argument. It should have one column per sample with
rows that correspond to 'coordinates'.}

\item{methylPropDF}{An object of matrix/data.frame/similar format
that contains the total number of reads for the loci in
'coordinates' argument. It should have one column per sample with
rows that correspond to 'coordinates'.}

\item{sample_names}{A character vector with sample names in the same
order as the columns of methylCountDF/coverageDF/methylPropDF
samples in the columns}
}
\value{
MIRAFormatBSDTList A list of data.tables containing
the methylation data. One data.table per sample with the column
names: 'chr', 'start' (methylation coordinate), 'methylCount' (number of
methylated reads), 'coverage' (total number of reads), and 
'methylProp' (proportion of methylated reads). The order of the
list is the order of samples in the columns of 
methylCountDF/coverageDF/methylPropDF. If sample names 
are explicitly given as input ('sample_names' argument)
or can be derived from other arguments to the function then
a named list will be returned.
}
\description{
Packages that use SummarizedExperiment-based classes for DNA methylation
data which could be converted with this function 
include "bsseq", "methylPipe", and "BiSeq" packages. 
Of the methylCountDF, coverageDF, and methylPropDF arguments, either 
methylPropDF must be given or both methylCountDF and coverageDF must
be given. After that, whichever is not given will be calculated 
from the others. If coverageDF and methylCountDF are both not given,
coverage will be assumed to be 1 at each site with a methylProp value.
Acceptable formats for the three "DF" parameters include:
data.frame, data.table, matrix, and DelayedMatrix classes.
If converting a BSseq object, see ?bsseqToDataTable for a convenient
wrapper of this function.
}
\examples{
 
data("exampleBSseqObj")
MIRAFormatBSDTList <- SummarizedExperimentToDataTable(coordinates = 
    bsseq::granges(exampleBSseqObj), 
    methylCountDF = bsseq::getCoverage(BSseq = exampleBSseqObj, type = "M"), 
    coverageDF = bsseq::getCoverage(BSseq = exampleBSseqObj, type = "Cov"),
    methylPropDF = bsseq::getMeth(BSseq = exampleBSseqObj, type = "raw"),
    sample_names = bsseq::sampleNames(exampleBSseqObj))
}
