% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/association.R
\name{findMirnaSNPs}
\alias{findMirnaSNPs}
\title{Find disease-associated SNPs occurring at DE-miRNA loci}
\usage{
findMirnaSNPs(mirnaObj, diseaseEFO)
}
\arguments{
\item{mirnaObj}{A \code{\link[=MirnaExperiment-class]{MirnaExperiment}} object
containing miRNA and gene data}

\item{diseaseEFO}{The EFO identifier of a disease of interest. This can be
identified with the \code{\link[=searchDisease]{searchDisease()}} function}
}
\value{
A \code{data.frame} containing details about disease-SNPs and the associated
differentially expressed miRNAs:
\itemize{
\item \code{variant} contains SNP identifiers;
\item \code{gene} defines the gene affected by a disease-SNP (it may be the miRNA
gene itself or the host gene of an intronic miRNA);
\item \code{miRNA.gene} specifies the DE-miRNA gene present;
\item \code{miRNA.precursor} specifies the name of the miRNA precursor affected
by disease-SNPs;
\item \code{chr} indicates the chromosome of SNPs;
\item \code{position} shows the SNP position;
\item \code{allele} displays possible alleles for this SNPs;
\item \code{distance} specifies the distance between SNPs and miRNAs;
\item \code{is_upstream} indicates whether SNP is upstream of miRNA gene;
\item \code{is_downstream} indicates whether SNP is downstream of miRNA gene;
\item \code{mirnaStrand} shows the strand;
\item \code{mirnaStartPosition} displays the start position of DE-miRNA gene;
\item \code{mirnaEndPosition} displays the end position of DE-miRNA gene.
}
}
\description{
This function allows to identify disease-associated genomic variants
affecting differentially expressed miRNA genes or their host genes.
To do so, this function uses \code{gwasrapidd} to retrieve SNPs-disease
associations, and then retains only SNPs that affect DE-miRNA genes or their
relative host genes (for intronic miRNAs).
}
\details{
SNPs occurring within miRNAs may have important effects on the biological
function of these transcripts. Indeed, a SNP present within a miRNA gene
might alter its expression or the spectrum of miRNA targets.

To retrieve disease-SNPs, this function uses \code{gwasrapidd} package, which
directly queries the NHGRI-EBI Catalog of published genome-wide association
studies. After running this function, the user can use the \code{\link[=mirVariantPlot]{mirVariantPlot()}}
function to produce a trackplot for visualizing the genomic location of
SNPs within miRNA genes.
}
\note{
To retrieve disease-associated SNPs, this function makes use of the
\code{gwasrapidd} package.
}
\examples{
# load example MirnaExperiment object
obj <- loadExamples()

\donttest{
# search disease
searchDisease("response to antidepressant")
disId <- "response to antidepressant"

# retrieve associated SNPs
association <- findMirnaSNPs(obj, disId)
}

}
\references{
Ramiro Magno, Ana-Teresa Maia, gwasrapidd: an R package to query, download
and wrangle GWAS catalog data, Bioinformatics, Volume 36, Issue 2, January
2020, Pages 649–650, \url{https://doi.org/10.1093/bioinformatics/btz605}
}
\author{
Jacopo Ronchi, \email{jacopo.ronchi@unimib.it}
}
