% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MODA.R
\name{WeightedModulePartitionHierarchical}
\alias{WeightedModulePartitionHierarchical}
\title{Modules detection by hierarchical clustering}
\usage{
WeightedModulePartitionHierarchical(datExpr, foldername, indicatename,
  cutmethod = c("Density", "Modularity"), power = 10)
}
\arguments{
\item{datExpr}{gene expression profile, rows are samples and columns genes}

\item{foldername}{where to store the clusters}

\item{indicatename}{normally a specific tag of condition}

\item{cutmethod}{cutting the dendrogram based on maximal average Density 
or Modularity}

\item{power}{the power parameter of WGCNA, W_{ij}=|cor(x_i,x_j)|^power}
}
\value{
The number of clusters
}
\description{
Module detection based on the optimal cutting height of dendrogram, which is 
selected to make the average density or modularity of resulting partition
maximal. The clustering and visulization function are from WGCNA.
}
\examples{
data(synthetic)
ResultFolder = 'ForSynthetic' # where middle files are stored
CuttingCriterion = 'Density' # could be Density or Modularity
indicator1 = 'X'     # indicator for data profile 1
indicator2 = 'Y'      # indicator for data profile 2
specificTheta = 0.1 #threshold to define condition specific modules
conservedTheta = 0.1#threshold to define conserved modules
intModules1 <- WeightedModulePartitionHierarchical(datExpr1,ResultFolder,
indicator1,CuttingCriterion) 
#mymodule <- getPartition(ResultFolder)
#randIndex(table(mymodule,truemodule),adjust=F)
}
\author{
Dong Li, \email{dxl466@cs.bham.ac.uk}
}
\references{
Langfelder, Peter, and Steve Horvath. "WGCNA: an R package for 
weighted correlation network analysis." BMC bioinformatics 9.1 (2008): 1.
}
\seealso{
\code{\link{PartitionDensity}}

\code{\link{PartitionModularity}}
}
\keyword{cutting}
\keyword{dendrogram}

