% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make.saturation.plots.r
\name{oncoprintPlot}
\alias{oncoprintPlot}
\title{Function to plot genomic events in the style of oncoPrint/cBioPortal}
\usage{
oncoprintPlot(
  summary.vec,
  snpmat.thisClus,
  amps.thisClus,
  dels.thisClus,
  fusions.thisClus,
  important.genes,
  band2gene,
  max.events,
  k
)
}
\arguments{
\item{summary.vec}{: named vector of the counts, named 'Event name':'Type'
where type is 'mut', 'amp', 'del', 'fus'. Mutations are in Entrez ID
Amp/Deletion CNV events are in genomic band location}

\item{snpmat.thisClus}{: SNP matrix subset to samples in current cluster}

\item{amps.thisClus}{: CNV matrix subset to samples in current cluster (just amplifications)}

\item{dels.thisClus}{: CNV matrix subset to samples in current cluster (just deletions)}

\item{fusions.thisClus}{: Fusion matrix subset to samples in current cluster}

\item{important.genes}{: well known genes to highlight in the analysis}

\item{band2gene}{: mapping of genomic location IDs to gene name: vector of 
HUGO gene ids, named by genomic location}

\item{max.events}{: maximum number of events to plot for the oncoplots}

\item{k}{: current cluster number}
}
\value{
oncoprint event plot
}
\description{
Function to plot genomic events in the style of oncoPrint/cBioPortal
}
\keyword{internal}
