% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultiOmicsSurvivalTest.R
\name{multiOmicsSurvivalPathwayTest}
\alias{multiOmicsSurvivalPathwayTest}
\title{Compute Multi Omics Survival in Pathways}
\usage{
multiOmicsSurvivalPathwayTest(
  omicsObj,
  graph,
  survFormula = "Surv(days, status) ~",
  autoCompleteFormula = TRUE,
  useTheseGenes = NULL,
  pathName = NULL,
  robust = FALSE,
  include_from_annot = FALSE
)
}
\arguments{
\item{omicsObj}{Object of class \code{Omics}}

\item{graph}{a pathway in \code{graphNEL}, \code{Pathway} or geneset format}

\item{survFormula}{a character with the formula to compute survival}

\item{autoCompleteFormula}{logical. If TRUE autocomplete the \code{survFormula}
using all the available covariates}

\item{useTheseGenes}{vector of genes used to filter pathways}

\item{pathName}{title of the pathway. If NULL and graph is \code{Pathway},
\code{graph@title} is used as title}

\item{robust}{logical, whether the robust mode should be used
for cox model analysis}

\item{include_from_annot}{logical. If TRUE compute cox model analysis
using additional covariates from \code{colData}}
}
\value{
\code{MultiOmicsPathway} object
}
\description{
Performs topological survival analysis using an \code{Omics} object.
}
\examples{
data(multiOmics)
data(reactSmall)

genesToUse <- row.names(multiOmics[[1]])

MOP_survival <- multiOmicsSurvivalPathwayTest(multiOmics, reactSmall[[1]],
    survFormula = "Surv(days, status) ~", autoCompleteFormula = TRUE,
    useTheseGenes = genesToUse
)

}
