% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparsim_functions.R
\name{sparsim_estimate_intensity}
\alias{sparsim_estimate_intensity}
\title{Estimate SPARSIm "intensity" parameter}
\usage{
sparsim_estimate_intensity(data)
}
\arguments{
\item{data}{normalized count data matrix (gene on rows, samples on columns). \code{rownames(data)} must contain gene names.}
}
\value{
An array of intensity values having \code{N_genes} elements (\code{N_genes = nrow(data)}). Array entries are named with gene names.
}
\description{
Function to estimate the intensity values from the genes in \code{data}. The intensity is computed as mean of normalized counts for each gene.
}
\details{
This function is a copy of the `SPARSIM_estimate_intensity` function from the
`SPARSim` package (v0.9.5), originally developed by Giacomo Baruzzo,
Ilaria Patuzzi, Barbara Di Camillo (2020). The original package is licensed
under the GPL-3 license.
This function is used in \code{sparsim_estimate_parameter_from_data} to compute SPARSim "intensity" parameter, given a real count table as input.
If the count table contains more than one experimental condition, then the function is applied to each experimental conditions.
}
