% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysisFunctions.R
\name{analyzeQuantification}
\alias{analyzeQuantification}
\title{Perform quantitative analysis on the MPRA data. This analysis aims to 
determine which sequences have a regulatory function, when no condition is 
being tested.}
\usage{
analyzeQuantification(obj, dnaDesign = ~1, rnaDesign = ~1, BPPARAM = NULL)
}
\arguments{
\item{obj}{the MpraObject}

\item{dnaDesign}{the design of the DNA counts}

\item{rnaDesign}{the design of the RNA counts}

\item{BPPARAM}{a parallelization object created by BiocParallel. This 
overwrites the BPPARAM object set in the object creation.}
}
\value{
the MpraObject, with populated models
}
\description{
\itemize{
  \item epirical: the model is fitted as specified, enabling future empirical
  testing (either empirical p-value if negative controls are provided, or a
  global devience analysis, see details in `test.empirical`)
  \item lrt: only available if negative controls are provided. A likelihood
  ratio test is used, with the null hypothesis a joint model of the controls
  and a given candidate sequence, and the alternative model being a separate
  model for controls and candidates.
}
}
\examples{
data <- simulateMPRA(tr = rep(2,10), nbatch=2, nbc=15)
obj <- MpraObject(dnaCounts = data$obs.dna, 
                  rnaCounts = data$obs.rna, 
                  colAnnot = data$annot)
obj <- estimateDepthFactors(obj, lib.factor = "batch", which.lib = "both")
obj <- analyzeQuantification(obj, dnaDesign = ~ batch + barcode, 
                              rnaDesign = ~1)
}
