#' @title granthamMatrix
#' @name granthamMatrix
#' @description This function creates a \code{granthamMatrix} object to be used
#' with the \code{rcpp_distSTRING} function. By default,the grantham matrix is
#' defined as from \code{Grantham 1974}.
#' (see \url{https://link.springer.com/article/10.1007/s00335-017-9704-9})
#' @return \code{matrix}
#' @references Grantham R. (1974). Amino Acid Difference Formula
#' to Help Explain Protein Evolution. \emph{Science},\bold{185(4154)},862-864.
#' @seealso \link[MSA2dist]{aastring2dist},\link[ape]{dist.dna}
#' @examples
#' granthamMatrix()
#' @export granthamMatrix
#' @author Kristian K Ullrich
## S R L P
## T A V G
## I F Y C
## H Q N K
## D E M W
## . - X

granthamMatrix<-function(){
    distances<-c(0,110,145,74,58,99,124,56,142,155,144,112,89,68,46,121,65,80,
    135,177,-1,-1,-1,
    110,0,102,103,71,112,96,125,97,97,77,180,29,43,86,26,96,54,91,101,-1,-1,-1,
    145,102,0,98,92,96,32,138,5,22,36,198,99,113,153,107,172,138,15,61,-1,-1,-1,
    74,103,98,0,38,27,68,42,95,114,110,169,77,76,91,103,108,93,87,147,-1,-1,-1,
    58,71,92,38,0,58,69,59,89,103,92,149,47,42,65,78,85,65,81,128,-1,-1,-1,
    99,112,96,27,58,0,64,60,94,113,112,195,86,91,111,106,126,107,84,148,-1,-1,
    -1,
    124,96,32,68,69,64,0,109,29,50,55,192,84,96,133,97,152,121,21,88,-1,-1,-1,
    56,125,138,42,59,60,109,0,135,153,147,159,98,87,80,127,94,98,127,184,-1,-1,
    -1,
    142,97,5,95,89,94,29,135,0,21,33,198,94,109,149,102,168,134,10,61,-1,-1,-1,
    155,97,22,14,103,13,50,153,21,0,22,205,100,116,158,102,177,140,28,40,-1,-1,
    -1,
    144,77,36,110,92,112,55,147,33,22,0,194,83,99,143,85,160,122,36,37,-1,-1,-1,
    112,180,198,169,149,195,192,159,198,205,194,0,174,154,139,202,154,170,196,
    215,-1,-1,-1,
    89,29,99,77,47,86,84,98,94,100,83,174,0,24,68,32,81,40,87,115,-1,-1,-1,
    68,43,113,76,42,91,96,87,109,116,99,154,24,0,46,53,61,29,101,130,-1,-1,-1,
    46,86,153,91,65,111,133,80,149,158,143,139,68,46,0,94,23,42,142,174,-1,-1,
    -1,
    121,26,107,103,78,106,97,127,102,102,85,202,32,53,94,0,101,56,95,110,-1,-1,
    -1,
    65,96,172,108,85,126,152,94,168,177,160,154,81,61,23,101,0,45,160,181,-1,-1,
    -1,
    80,54,138,93,65,107,121,98,134,140,122,170,40,29,42,56,45,0,126,152,-1,-1,
    -1,
    135,91,15,87,81,84,21,127,10,28,36,196,87,101,142,95,160,126,0,67,-1,-1,-1,
    177,101,61,147,128,148,88,184,61,40,37,215,115,130,174,110,181,152,67,0,-1,
    -1,-1,
    -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
    -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
    -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
    )
    granthamMatrix<-matrix(distances,ncol=23,nrow=23)
    colnames(granthamMatrix)<-rownames(granthamMatrix)<-c("S","R","L","P","T",
    "A","V","G","I","F","Y","C","H","Q","N","K","D","E","M","W",".","-","X")
    return(granthamMatrix)
}
