% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdsstring2codonaln.R
\name{cdsstring2codonaln}
\alias{cdsstring2codonaln}
\title{cdsstring2codonaln}
\usage{
cdsstring2codonaln(
  cds,
  aa,
  type = "global",
  substitutionMatrix = "BLOSUM62",
  gapOpening = 10,
  gapExtension = 0.5,
  remove.gaps = FALSE
)
}
\arguments{
\item{cds}{two sequences \code{DNAStringSet} [mandatory]}

\item{aa}{two sequences \code{AAStringSet} [mandatory]}

\item{type}{type of alignment (see
\code{\link[pwalign]{pairwiseAlignment}}) [default: global]}

\item{substitutionMatrix}{substitution matrix representing the fixed
substitution scores for an alignment (see
\code{\link[pwalign]{pairwiseAlignment}}) [default: BLOSUM62]}

\item{gapOpening}{the cost for opening a gap in the alignment (see
\code{\link[pwalign]{pairwiseAlignment}}) [default: 10]}

\item{gapExtension}{the incremental cost incurred along the length of the
gap in the alignment (see \code{\link[pwalign]{pairwiseAlignment}})
[default: 0.5]}

\item{remove.gaps}{specify if gaps in the codon alignment should be removed
[default: FALSE]}
}
\value{
codon alignment as \code{DNAStringSet}
}
\description{
This function takes two sequences as \code{DNAStringSet},
and their corresponding \code{AAStringSet}, calculates
a global alignment and converts this alignment back into a codon alignment.
}
\examples{
## define two cds sequences
cds <- Biostrings::DNAStringSet(c("ATGCAACATTGC", "ATGCATTGC"))
names(cds) <- c("cds1", "cds2")
## get protein alignment
aa <- MSA2dist::cds2aa(cds)
cdsstring2codonaln(cds, aa)
}
\references{
Pagès, H et al. (2014) Biostrings: Efficient manipulation of
biological strings. \emph{R package version}, \bold{2(0)}.
}
\seealso{
\code{\link[pwalign]{pairwiseAlignment}}
}
\author{
Kristian K Ullrich
}
