data(hiv)

test_that("cdsstring2codonaln() outputs DNAStringSet", {
    cds <- Biostrings::DNAStringSet(c("ATGCAACATTGC", "ATGCATTGC"))
    names(cds) <- c("cds1", "cds2")
    aa <- MSA2dist::cds2aa(cds)
    cds1.cds2.aln <- cdsstring2codonaln(cds, aa)
    expect_true(as.character(cds1.cds2.aln[1]) == "ATGCAACATTGC")
    expect_true(as.character(cds1.cds2.aln[2]) == "ATG---CATTGC")
    cds1.cds2.aln.rem <- cdsstring2codonaln(cds, aa, remove.gaps=TRUE)
    expect_true(as.character(cds1.cds2.aln.rem[1]) == "ATGCATTGC")
    expect_true(as.character(cds1.cds2.aln.rem[2]) == "ATGCATTGC")
    cds1.cds2.aln.local <- cdsstring2codonaln(cds, aa, type="local")
    expect_true(as.character(cds1.cds2.aln.local[1]) == "CAACATTGC")
    expect_true(as.character(cds1.cds2.aln.local[2]) == "ATGCATTGC")
})
