% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResistanceBarcodePlotLiP.R
\name{ResistanceBarcodePlotLiP}
\alias{ResistanceBarcodePlotLiP}
\title{Proteolytic Resistance Barcode plot. Shows accessibility score of different
fully tryptic peptides in a protein.}
\usage{
ResistanceBarcodePlotLiP(
  data,
  fasta_file,
  which.prot = "all",
  which.condition = "all",
  differential_analysis = FALSE,
  which.comp = "all",
  adj.pvalue.cutoff = 0.05,
  FC.cutoff = 0,
  width = 12,
  height = 4,
  address = "",
  isPlotly = FALSE
)
}
\arguments{
\item{data}{list of data.tables containing LiP and TrP data in MSstatsLiP
format. Should be output of summarization function as
\code{\link[MSstatsLiP]{dataSummarizationLiP}}.}

\item{fasta_file}{A string of path to a FASTA file}

\item{which.prot}{a list of peptides to be visualized. Default is "all" which
will plot a separate barcode plot for each protein.}

\item{which.condition}{a list of conditions to be visualized. Default is
"all" which will plot all conditions for a single protein in the same barcode
plot.}

\item{differential_analysis}{a boolean indicating if a barcode plot showing
the differential analysis should be plotted. If this is selected you must
have performed differential analysis on the proteoltic data in the
\code{calculateProteolyticResistance} function. Default is \code{FALSE}.}

\item{which.comp}{a list of comparisons to be visualized, if differential
analysis is passed to plot_differential variable. Default is "all"
which will plot a separate barcode plot for each comparison and protein.}

\item{adj.pvalue.cutoff}{Default is .05. Alpha value for testing significance
of model output.}

\item{FC.cutoff}{Default is 0. Minimum absolute FC before a comparison will
be considered significant.}

\item{width}{width of the saved file. Default is 10.}

\item{height}{height of the saved file. Default is 10.}

\item{address}{the name of folder that will store the results. Default
folder is the current working directory. The other assigned folder has to
be existed under the current working directory. An output pdf file is
automatically created with the default name of "VolcanoPlot.pdf" or
"Heatmap.pdf". The command address can help to specify where to store the
file as well as how to modify the beginning of the file name. If
address=FALSE, plot will be not saved as pdf file but showed in window}

\item{isPlotly}{Parameter to use Plotly or ggplot2. If set to TRUE, MSstats
will save Plotly plots as HTML files. If set to FALSE MSstats will save ggplot2 plots
as PDF files}
}
\value{
plot or pdf
}
\description{
Proteolytic Resistance Barcode plot. Shows accessibility score of different
fully tryptic peptides in a protein.
}
\examples{
# Specify Fasta path
fasta_path = system.file("extdata", "ExampleFastaFile.fasta", package="MSstatsLiP")

# Use model data to create Barcode Plot
#ResistanceBarcodePlotLiP(MSstatsLiP_model, fasta_path)

}
