% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CUSUMChart.R
\name{CUSUMChart}
\alias{CUSUMChart}
\title{A function to create cumulative sum charts for mean (CUSUMm) and cumulative sum charts for variability (CUSUMv) control charts}
\usage{
CUSUMChart(
  data = NULL,
  peptide,
  L = 1,
  U = 5,
  metric,
  normalization = TRUE,
  ytitle = "CUSUMm",
  type = "mean",
  selectMean = NULL,
  selectSD = NULL,
  referenceValue = 0.5,
  decisionInterval = 5
)
}
\arguments{
\item{data}{comma-separated (.csv), metric file. It should contain a "Precursor" column and the metrics columns. It should also include "Annotations" for each observation.}

\item{peptide}{the name of precursor of interest.}

\item{L}{Lower bound of the guide set.}

\item{U}{Upper bound of the guide set.}

\item{metric}{the name of metric of interest.}

\item{normalization}{TRUE if metric is standardized and FALSE if not standardized.}

\item{ytitle}{the y-axis title of the plot.  Defaults to "CUSUMm". The x-axis title is by default "Time : name of peptide"}

\item{type}{the type of the control chart. Two values can be assigned, "mean" or "variability". Default is "mean"}

\item{selectMean}{the mean of a metric. It is used when mean is known. It is NULL when mean is not known.  The default is NULL.}

\item{selectSD}{the standard deviation of a metric. It is used when standard deviation is known. It is NULL when mean is not known. The default is NULL.}

\item{referenceValue}{the value that is used to tune the control chart for a proper shift size}

\item{decisionInterval}{the threshold to detect an out-of-control observation}
}
\value{
A plot of pozitive and negative CUSUM statistics versus time per peptide and metric generated from \code{CUSUM.data.prepare} data frame.
}
\description{
A function to create cumulative sum charts for mean (CUSUMm) and cumulative sum charts for variability (CUSUMv) control charts
}
\examples{
# First process the data to make sure it's ready to use
sampleData <- DataProcess(S9Site54)
head(sampleData)
# Find the name of the peptides
levels(sampleData$Precursor)
# Calculate CUSUM statistics
CUSUMChart(data = sampleData, peptide = "VLVLDTDYK", metric = "BestRetentionTime")
CUSUMChart(data = sampleData, peptide = "VLVLDTDYK", metric = "BestRetentionTime",
           ytitle = "CUSUMv", type = "variability")
CUSUMChart(data = sampleData, peptide = "VLVLDTDYK", metric = "BestRetentionTime",
           selectMean = 27.78, selectSD = 8.19)
CUSUMChart(data = sampleData, peptide = "DDGSWEVIEGYR", metric = "TotalArea")
CUSUMChart(data = sampleData, peptide = "DDGSWEVIEGYR", metric = "TotalArea",
           selectMean = 35097129, selectSD = 34132861)
CUSUMChart(data = sampleData, peptide = "TAAYVNAIEK", metric = "MaxFWHM")
}
\keyword{Sum,}
\keyword{chart}
\keyword{control}
\keyword{cumulative}
