% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Fit_Isotonic_Regression.R
\name{fitIsotonicRegression}
\alias{fitIsotonicRegression}
\title{Fit Isotonic Regression Model}
\usage{
fitIsotonicRegression(
  x,
  y,
  w = rep(1, length(y)),
  increasing = FALSE,
  transform_x = TRUE,
  ratio_y = FALSE,
  test_significance = FALSE
)
}
\arguments{
\item{x}{Numeric vector of dose values.}

\item{y}{Numeric vector of response values.}

\item{w}{Optional numeric vector of weights. Defaults to equal weights.}

\item{increasing}{Logical. If TRUE, fits a non-decreasing model. If FALSE, fits non-increasing.}

\item{transform_x}{Logical. If TRUE, applies log10(x + 1) transformation. Default is TRUE.}

\item{ratio_y}{Logical. If TRUE, converts log2 abundance to ratios relative to DMSO. Default is FALSE.}

\item{test_significance}{Logical. If TRUE, performs F-test to assess significance.}
}
\value{
A list representing the isotonic regression model (class = "isotonic_model").
}
\description{
Fits an isotonic regression model to protein intensity data with log-transformed drug doses.
Optionally performs an F-test to assess the significance of the dose-response curve.
}
