% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groupComparison.R
\name{MSstatsGroupComparisonSingleProtein}
\alias{MSstatsGroupComparisonSingleProtein}
\title{Group comparison for a single protein}
\usage{
MSstatsGroupComparisonSingleProtein(
  single_protein,
  contrast_matrix,
  repeated,
  groups,
  samples_info,
  save_fitted_models,
  has_imputed
)
}
\arguments{
\item{single_protein}{data.table with summarized data for a single protein}

\item{contrast_matrix}{contrast matrix}

\item{repeated}{if TRUE, repeated measurements will be modeled}

\item{groups}{unique labels of experimental conditions}

\item{samples_info}{number of runs per group}

\item{save_fitted_models}{if TRUE, fitted model will be saved.
If not, it will be replaced with NULL}

\item{has_imputed}{TRUE if missing values have been imputed}
}
\description{
Group comparison for a single protein
}
\examples{
QuantData <- dataProcess(SRMRawData, use_log_file = FALSE)
group_comparison_input <- MSstatsPrepareForGroupComparison(QuantData)
levels(QuantData$ProteinLevelData$GROUP)
comparison <- matrix(c(-1,0,0,0,0,0,1,0,0,0),nrow=1)
row.names(comparison) <- "T7-T1"
groups = levels(QuantData$ProteinLevelData$GROUP)
colnames(comparison) <- groups[order(as.numeric(groups))]
samples_info <- getSamplesInfo(QuantData)
repeated <- checkRepeatedDesign(QuantData)
single_output <- MSstatsGroupComparisonSingleProtein(
  group_comparison_input[[1]], comparison, repeated, groups, samples_info,
  FALSE, TRUE)
single_output # same as a single element of MSstatsGroupComparison output

}
