\name{MWAS_filter}
\alias{MWAS_filter}
\title{Filter MWAS results by p-value and/or CV}
\description{
This function allows filtering the output matrix from "MWAS_stats()", by p-value
and/or coefficient of variation (CV).
}
\usage{
MWAS_filter(MWAS_matrix, type = "pvalue", alpha_th = 0.05, CV_th = 0.30, sort = FALSE)
}
\arguments{
  \item{MWAS_matrix}{numeric matrix generated by the function "MWAS_stats()".}
  \item{type}{character constant indicating the filtering criteria. If type = "pvalue",
  only metabolic variables with p-value below alpha_th will be retained in the
  MWAS_matrix. If type = "CV", only metabolic variables with CV below CV_th will
  be retained. If type = "all", only metabolic variables with CV below CV_th and
  p-value below alpha_th will be retained.}
  \item{alpha_th}{numeric value indicating the significance threshold.}
  \item{CV_th}{numeric value indicating the CV threshold.}
  \item{sort}{logical constant indicating whether the filter MWAS_matrix will be
  sorted based on p-values.}
}
\value{
A numeric matrix corresponding to the filtered MWAS_matrix. The matrix has an
additional column, which indicates the index of each metabolic variable in the original
MWAS_matrix.
}
\examples{
## Load data
data(targetMetabo_SE)

## Test for association between diabetes and target_metabolites
T2D_model <- MWAS_stats (targetMetabo_SE, disease_id = "T2D",
                         assoc_method = "logistic")

## Filter T2D_model by p-value
MWAS_filter(T2D_model, type = "pvalue", alpha_th = 0.001, sort = TRUE)

## Subset targetMetabo_SE based on pvalue_filter
pvalue_filter <- MWAS_filter(T2D_model, type = "pvalue", alpha_th = 0.001)
index_features <- pvalue_filter[, 4]
targetMetabo_SE[index_features, ]
}
