% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{getBinaryMatrix}
\alias{getBinaryMatrix}
\alias{getBinaryMatrix,phyloTree-method}
\title{getBinaryMatrix}
\usage{
getBinaryMatrix(object)

\S4method{getBinaryMatrix}{phyloTree}(object)
}
\arguments{
\item{object}{An object of phyloTree}
}
\value{
Binary matrix of phyloTree
}
\description{
getBinaryMatrix
}
\examples{
maf.File <- system.file("extdata/", "CRC_HZ.maf", package = "MesKit")
clin.File <- system.file("extdata/", "CRC_HZ.clin.txt", package = "MesKit")
ccf.File <- system.file("extdata/", "CRC_HZ.ccf.tsv", package = "MesKit")
maf <- readMaf(mafFile=maf.File, clinicalFile = clin.File, ccfFile=ccf.File, refBuild="hg19")
phyloTree <- getPhyloTree(maf)
getBinaryMatrix(phyloTree$V402)
}
