% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subMaf.R
\name{subMaf}
\alias{subMaf}
\title{Subset Maf object}
\usage{
subMaf(
  maf,
  mafObj = FALSE,
  patient.id = NULL,
  geneList = NULL,
  chrSilent = NULL,
  mutType = "All",
  use.indel = TRUE,
  min.vaf = 0,
  max.vaf = 1,
  min.average.vaf = 0,
  min.ccf = 0,
  min.ref.depth = 0,
  min.alt.depth = 0,
  min.total.depth = 0,
  clonalStatus = NULL,
  use.adjVAF = FALSE,
  use.tumorSampleLabel = FALSE
)
}
\arguments{
\item{maf}{Maf or MafList object generated by \code{\link{readMaf}} function.}

\item{mafObj}{return Maf class. (Default: FALSE).}

\item{patient.id}{Select the specific patients. Default NULL, all patients are included.}

\item{geneList}{A list of genes to restrict the analysis. Default NULL.}

\item{chrSilent}{Chromosomes excluded in the analysis. e.g, 1, 2, X, Y. Default NULL.}

\item{mutType}{Select Proper variant classification you need. Default "All". Option: "nonSyn".}

\item{use.indel}{Logical value. Whether to use INDELs besides somatic SNVs. (Default: TRUE).}

\item{min.vaf}{The minimum VAF for filtering variants. Default 0.}

\item{max.vaf}{The maximum VAF for filtering variants. Default 1.}

\item{min.average.vaf}{The minimum tumor average VAF for filtering variants. Default 0.}

\item{min.ccf}{The minimum CCF for filtering variants. Default NULL.}

\item{min.ref.depth}{The minimum reference allele depth for filtering variants. Default 0.}

\item{min.alt.depth}{The minimum alteratation allele depth for filtering variants. Default 0.}

\item{min.total.depth}{The minimum total allele depth for filtering variants. Default 0.}

\item{clonalStatus}{Subset by clonal status. Default NULL. Option: "Clonal","Subclonal".}

\item{use.adjVAF}{Use adjusted VAF in analysis when adjusted VAF or CCF is available. Default FALSE.}

\item{use.tumorSampleLabel}{Logical (Default: FALSE). Rename the 'Tumor_Sample_Barcode' by 'Tumor_Sample_Label'.}
}
\value{
Maf object or Maf data.
}
\description{
Subset Maf object
}
\examples{
maf.File <- system.file("extdata/", "CRC_HZ.maf", package = "MesKit")
clin.File <- system.file("extdata/", "CRC_HZ.clin.txt", package = "MesKit")
ccf.File <- system.file("extdata/", "CRC_HZ.ccf.tsv", package = "MesKit")
maf <- readMaf(mafFile=maf.File, clinicalFile = clin.File, ccfFile=ccf.File, refBuild="hg19")
maf_data <- subMaf(maf)
}
