% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linkDf.R
\name{createLinkDf}
\alias{createLinkDf}
\title{Create a data frame which contains features to link (indices)}
\usage{
createLinkDf(similarityMatrix, sps, condition, lower, upper)
}
\arguments{
\item{similarityMatrix}{\code{matrix}, a similarity matrix that contains the
similarity measure between all precursors in the data set}

\item{sps}{\code{Spectra} object containing spectral data corresponding to 
features in \code{similarityMatrix}}

\item{condition}{\code{character} \code{vector} containing the
conditions/samples for which a \code{linkDf} is created}

\item{lower}{\code{numeric(1)}, threshold value for similarity values,
linked features below this value will not be included}

\item{upper}{\code{numeric(1)}, threshold value for similarity values,
linked features above this value will not be included}
}
\value{
\code{createLinkDf} returns a \code{data.frame} that gives per each 
row information on linked features
}
\description{
Create a data frame which contains features to link (indices).
}
\details{
\code{lower} and \code{upper} are numerical values and truncate 
spectra based on their similarity. The function \code{createLinkDf} is 
a wrapper for the functions \code{createLink0df} and \code{thresholdLinkDf}.
}
\examples{
data("spectra", package = "MetCirc")
data("similarityMat", package = "MetCirc")
link0df <- createLink0df(similarityMatrix = similarityMat,
    sps = sps_tissue, condition = c("SPL", "LIM", "ANT", "STY"))
createLinkDf(similarityMatrix = similarityMat, sps = sps_tissue,
    condition = c("SPL", "LIM", "ANT", "STY"), lower = 0.5, upper = 1)

}
\author{
Thomas Naake, \email{thomasnaake@googlemail.com}
}
